/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.document.signing.gateway.controller;

import com.ssl.document.signing.gateway.csc.CredentialInfo;
import com.ssl.document.signing.gateway.csc.CscApi;
import com.ssl.document.signing.gateway.exception.CscApiException;
import com.ssl.document.signing.gateway.exception.PdfException;
import com.ssl.document.signing.gateway.pdf.PdfSignature;
import com.ssl.document.signing.gateway.pdf.PdfSignatureInfo;
import com.ssl.document.signing.gateway.vo.ErrorResponse;
import com.ssl.document.signing.gateway.vo.EsealPdfRequest;
import com.ssl.document.signing.gateway.vo.EsealPdfResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PDFSignaturesController {
    @Value(value="${csc.url}")
    private String cscUrl;
    @Value(value="${tsa.url}")
    private String tsaUrl;
    private static final Logger logger = LogManager.getLogger(PDFSignaturesController.class);

    @RequestMapping(value={"/v1/pdf/eseal"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity esealPdf(@RequestBody EsealPdfRequest pdfRequest, HttpServletRequest request) throws Exception {
        try {
            float x = -1.0f;
            float y = -1.0f;
            float width = -1.0f;
            float height = -1.0f;
            int pageNumber = -1;
            byte[] handSigBytes = null;
            byte[] pdfDocBytes = null;
            String accessToken = request.getHeader("Authorization");
            if (accessToken == null || accessToken.isEmpty()) {
                logger.info("access token not present in request");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "access token not present in request"));
            }
            if (request.getContentType() == null || !request.getContentType().equals("application/json")) {
                logger.info("request content type must be application/json");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "request content type must be application/json"));
            }
            String credentialId = pdfRequest.getCredentialId();
            if (credentialId == null || credentialId.isEmpty()) {
                logger.info("credential_id not present in request body");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "credential_id not present in request body"));
            }
            String pdf = pdfRequest.getPdf();
            if (pdf == null || pdf.isEmpty()) {
                logger.info("pdf document not present in request body");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "pdf document not present in request body"));
            }
            try {
                pdfDocBytes = Base64.getDecoder().decode(pdfRequest.getPdf());
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "invalid base64 encoding of PDF document"));
            }
            if (pdfRequest.getSignatureFieldPosition() != null && pdfRequest.getPageNumber() != null) {
                x = pdfRequest.getSignatureFieldPosition().getX();
                y = pdfRequest.getSignatureFieldPosition().getY();
                width = pdfRequest.getSignatureFieldPosition().getWidth();
                height = pdfRequest.getSignatureFieldPosition().getHeight();
                pageNumber = pdfRequest.getPageNumber();
            }
            if (pdfRequest.getHandSignature() != null) {
                try {
                    handSigBytes = Base64.getDecoder().decode(pdfRequest.getHandSignature());
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                    return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "invalid base64 encoding of hand signature format"));
                }
            }
            CscApi cscAPI = new CscApi(accessToken, this.cscUrl);
            CredentialInfo credentialInfo = cscAPI.getCredentialInfo(credentialId);
            List certsList = credentialInfo.getCerts();
            logger.info("signer certificate subject DN: " + ((X509Certificate)certsList.get(0)).getSubjectDN());
            long pdfDocId = new Random().nextLong();
            Calendar signDate = Calendar.getInstance();
            PdfSignatureInfo signatureInfo = new PdfSignatureInfo();
            signatureInfo.setDocumentId(pdfDocId);
            signatureInfo.setX(x);
            signatureInfo.setY(y);
            signatureInfo.setWidth(width);
            signatureInfo.setHeight(height);
            signatureInfo.setPageNo(pageNumber);
            signatureInfo.setSigningReason(pdfRequest.getSigningReason());
            signatureInfo.setSigningLocation(pdfRequest.getSigningLocation());
            signatureInfo.setContactInfo(pdfRequest.getContactInfo());
            signatureInfo.setSignDate(signDate);
            signatureInfo.setCredentialId(credentialId);
            signatureInfo.setHandSignature(handSigBytes);
            PdfSignature pdfSig = new PdfSignature(pdfDocBytes, certsList);
            pdfSig.setSignatureInfo(signatureInfo);
            pdfSig.setTsaUrl(this.tsaUrl);
            String hash = pdfSig.getHash();
            logger.info("computed pdf hash: " + hash);
            String sad = cscAPI.getCredentialsAuthorize(signatureInfo.getCredentialId(), 1, new String[]{hash}, null);
            String signature = cscAPI.signHash(signatureInfo.getCredentialId(), sad, new String[]{hash}, credentialInfo.getSignatureAlgorithm())[0];
            byte[] signedTimestampedPdf = pdfSig.embedSignature(Base64.getDecoder().decode(signature), credentialInfo.getSignatureAlgorithm());
            logger.info("pdf successfully signed and timestamped");
            List revInfos = PdfSignature.getRevocationInformation((List)certsList);
            byte[] signedDocument = PdfSignature.longTermValidation((byte[])signedTimestampedPdf, (List)revInfos);
            logger.info("revocation information embedded in order to make it LTV");
            EsealPdfResponse response = new EsealPdfResponse();
            response.setSignedPdf(Base64.getEncoder().encodeToString(signedDocument));
            return ResponseEntity.ok().body((Object)response);
        }
        catch (CscApiException | PdfException ex) {
            logger.error("", ex);
            return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", ex.getMessage()));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return ResponseEntity.internalServerError().build();
        }
    }

    @RequestMapping(value={"/v1/pdf/timestamp"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity timestampPdf(@RequestBody EsealPdfRequest pdfRequest, HttpServletRequest request) throws Exception {
        try {
            byte[] pdfDocBytes = null;
            String accessToken = request.getHeader("Authorization");
            if (accessToken == null || accessToken.isEmpty()) {
                logger.info("access token not present in request");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "access token not present in request"));
            }
            if (request.getContentType() == null || !request.getContentType().equals("application/json")) {
                logger.info("request content type must be application/json");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "request content type must be application/json"));
            }
            String pdf = pdfRequest.getPdf();
            if (pdf == null || pdf.isEmpty()) {
                logger.info("pdf document not present in request body");
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "pdf document not present in request body"));
            }
            try {
                pdfDocBytes = Base64.getDecoder().decode(pdfRequest.getPdf());
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", "invalid base64 encoding of PDF document"));
            }
            CscApi cscAPI = new CscApi(accessToken, this.cscUrl);
            cscAPI.getCredentialIDs("DS");
            logger.info("access token is valid");
            byte[] timestampDocument = PdfSignature.timestampDocument((byte[])pdfDocBytes, (String)this.tsaUrl);
            logger.info("pdf successfully timestamped");
            EsealPdfResponse response = new EsealPdfResponse();
            response.setSignedPdf(Base64.getEncoder().encodeToString(timestampDocument));
            return ResponseEntity.ok().body((Object)response);
        }
        catch (CscApiException | PdfException ex) {
            logger.error("", ex);
            return ResponseEntity.badRequest().body((Object)this.sendErrorResponse("invalid_request", ex.getMessage()));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            return ResponseEntity.internalServerError().build();
        }
    }

    private ErrorResponse sendErrorResponse(String error, String errorDescription) {
        ErrorResponse response = new ErrorResponse();
        response.setError(error);
        response.setErrorDescription(errorDescription);
        return response;
    }
}

