/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.document.signing.gateway.pdf;

import com.ssl.document.signing.gateway.exception.PdfException;
import com.ssl.document.signing.gateway.http.HTTPClient;
import com.ssl.document.signing.gateway.pdf.PdfSignatureInfo;
import com.ssl.document.signing.gateway.pdf.PdfSignatureUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Store;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdfSignature {
    private static final Logger logger = LogManager.getLogger(PdfSignature.class);
    private final byte[] pdfDocBytes;
    private final List<X509Certificate> signerCertChain;
    private PdfSignatureInfo signatureInfo;
    private String tsaUrl;

    public PdfSignature(byte[] pdfDocBytes, List<X509Certificate> signerCertChain) {
        this.pdfDocBytes = pdfDocBytes;
        this.signerCertChain = signerCertChain;
    }

    public void setSignatureInfo(PdfSignatureInfo signatureInfo) {
        this.signatureInfo = signatureInfo;
    }

    public void setTsaUrl(String tsaUrl) {
        this.tsaUrl = tsaUrl;
    }

    public String getHash() throws Exception {
        PDDocument document;
        ByteArrayOutputStream outputPDF = new ByteArrayOutputStream();
        try {
            document = PDDocument.load((byte[])this.pdfDocBytes);
            document.setDocumentId(Long.valueOf(this.signatureInfo.getDocumentId()));
        }
        catch (IOException ex) {
            throw new PdfException("invalid PDF format");
        }
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
        if (this.signatureInfo.getSigningLocation() != null) {
            signature.setLocation(this.signatureInfo.getSigningLocation());
        }
        if (this.signatureInfo.getSigningReason() != null) {
            signature.setReason(this.signatureInfo.getSigningReason());
        }
        if (this.signatureInfo.getContactInfo() != null) {
            signature.setContactInfo(this.signatureInfo.getContactInfo());
        }
        signature.setSignDate(this.signatureInfo.getSignDate());
        SignatureOptions options = new SignatureOptions();
        options.setPreferredSignatureSize(13000);
        if (this.signatureInfo.getX() != -1.0f && this.signatureInfo.getY() != -1.0f && this.signatureInfo.getWidth() != -1.0f && this.signatureInfo.getHeight() != -1.0f && this.signatureInfo.getPageNo() != -1) {
            PDPage pdPage = document.getPage(this.signatureInfo.getPageNo());
            options.setPage(this.signatureInfo.getPageNo());
            options.setVisualSignature(new PdfSignatureUtils(this.signatureInfo.getX(), this.signatureInfo.getY(), this.signatureInfo.getWidth(), this.signatureInfo.getHeight(), this.signatureInfo.getHandSignature()).createVisualSignatureTemplate(pdPage, signature, ((X509Certificate)this.signerCertChain.get(0)).getSubjectDN().getName()));
        }
        document.addSignature(signature, options);
        ExternalSigningSupport externalSigning = document.saveIncrementalForExternalSigning((OutputStream)outputPDF);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(IOUtils.toByteArray((InputStream)externalSigning.getContent()));
        byte[] contentDigest = messageDigest.digest();
        ASN1EncodableVector signedAttributesVector = new ASN1EncodableVector();
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, (ASN1Set)new DERSet((ASN1Encodable)PKCSObjectIdentifiers.data)));
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(contentDigest))));
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(this.signatureInfo.getSignDate().getTime()))));
        messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(((X509Certificate)this.signerCertChain.get(0)).getEncoded());
        ESSCertIDv2 essCert = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), null), messageDigest.digest());
        SigningCertificateV2 scv2 = new SigningCertificateV2(new ESSCertIDv2[]{essCert});
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)scv2)));
        DERSet signedAttributes = new DERSet(signedAttributesVector);
        messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(signedAttributes.getEncoded());
        String hashToSign = Base64.getEncoder().encodeToString(messageDigest.digest());
        IOUtils.close((Closeable)options);
        outputPDF.close();
        document.close();
        return hashToSign;
    }

    public byte[] embedSignature(byte[] pkcs1Signature, String sigAlgo) throws Exception {
        PDDocument document;
        ByteArrayOutputStream outputPDF = new ByteArrayOutputStream();
        try {
            document = PDDocument.load((byte[])this.pdfDocBytes);
            document.setDocumentId(Long.valueOf(this.signatureInfo.getDocumentId()));
        }
        catch (IOException ex) {
            throw new PdfException("invalid PDF format");
        }
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
        if (this.signatureInfo.getSigningLocation() != null) {
            signature.setLocation(this.signatureInfo.getSigningLocation());
        }
        if (this.signatureInfo.getSigningReason() != null) {
            signature.setReason(this.signatureInfo.getSigningReason());
        }
        if (this.signatureInfo.getContactInfo() != null) {
            signature.setContactInfo(this.signatureInfo.getContactInfo());
        }
        signature.setSignDate(this.signatureInfo.getSignDate());
        SignatureOptions options = new SignatureOptions();
        options.setPreferredSignatureSize(13000);
        if (this.signatureInfo.getX() != -1.0f && this.signatureInfo.getY() != -1.0f && this.signatureInfo.getWidth() != -1.0f && this.signatureInfo.getHeight() != -1.0f && this.signatureInfo.getPageNo() != -1) {
            PDPage pdPage = document.getPage(this.signatureInfo.getPageNo());
            options.setPage(this.signatureInfo.getPageNo());
            options.setVisualSignature(new PdfSignatureUtils(this.signatureInfo.getX(), this.signatureInfo.getY(), this.signatureInfo.getWidth(), this.signatureInfo.getHeight(), this.signatureInfo.getHandSignature()).createVisualSignatureTemplate(pdPage, signature, ((X509Certificate)this.signerCertChain.get(0)).getSubjectDN().getName()));
        }
        document.addSignature(signature, options);
        ExternalSigningSupport externalSigning = document.saveIncrementalForExternalSigning((OutputStream)outputPDF);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(IOUtils.toByteArray((InputStream)externalSigning.getContent()));
        byte[] contentDigest = messageDigest.digest();
        ASN1EncodableVector signedAttributesVector = new ASN1EncodableVector();
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, (ASN1Set)new DERSet((ASN1Encodable)PKCSObjectIdentifiers.data)));
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(contentDigest))));
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(this.signatureInfo.getSignDate().getTime()))));
        messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(((X509Certificate)this.signerCertChain.get(0)).getEncoded());
        ESSCertIDv2 essCert = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), null), messageDigest.digest());
        SigningCertificateV2 scv2 = new SigningCertificateV2(new ESSCertIDv2[]{essCert});
        signedAttributesVector.add((ASN1Encodable)new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)scv2)));
        DERSet signedAttributes = new DERSet(signedAttributesVector);
        DERSet unSignedAttributes = null;
        if (this.tsaUrl != null) {
            ASN1EncodableVector unSignedAttributesVector = new ASN1EncodableVector();
            unSignedAttributesVector.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.14"), (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])PdfSignature.signatureTimestamp((byte[])pkcs1Signature, (String)this.tsaUrl)))));
            unSignedAttributes = new DERSet(unSignedAttributesVector);
        }
        Certificate signerCert = Certificate.getInstance((Object)((X509Certificate)this.signerCertChain.get(0)).getEncoded());
        SignerInfo signerInfo = new SignerInfo(new SignerIdentifier(new IssuerAndSerialNumber(signerCert)), new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), null), (ASN1Set)signedAttributes, new AlgorithmIdentifier(new ASN1ObjectIdentifier(sigAlgo), null), (ASN1OctetString)new DEROctetString(pkcs1Signature), (ASN1Set)unSignedAttributes);
        ASN1EncodableVector digestAlgorithmsVector = new ASN1EncodableVector();
        digestAlgorithmsVector.add((ASN1Encodable)new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), null));
        ContentInfo encapContentInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
        ASN1EncodableVector certificatesVector = new ASN1EncodableVector();
        for (X509Certificate cert : this.signerCertChain) {
            certificatesVector.add((ASN1Encodable)Certificate.getInstance((Object)cert.getEncoded()));
        }
        ASN1EncodableVector signerInfosVector = new ASN1EncodableVector();
        signerInfosVector.add((ASN1Encodable)signerInfo.toASN1Primitive());
        SignedData signedData = new SignedData((ASN1Set)new DERSet(digestAlgorithmsVector), encapContentInfo, (ASN1Set)new DERSet(certificatesVector), null, (ASN1Set)new DERSet(signerInfosVector));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
        byte[] cades = contentInfo.getEncoded();
        externalSigning.setSignature(cades);
        IOUtils.close((Closeable)options);
        outputPDF.close();
        document.close();
        return outputPDF.toByteArray();
    }

    public static byte[] signatureTimestamp(byte[] pkcs1Signature, String tsaUrl) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(pkcs1Signature);
        byte[] messageImprint = md.digest();
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1"), messageImprint, nonce);
        byte[] tspRequestBytes = request.getEncoded();
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/timestamp-query");
        HTTPClient client = new HTTPClient(tsaUrl, reqHeaders);
        client.sendPOSTRequest(tspRequestBytes);
        byte[] timestampRes = client.getBody();
        TimeStampResponse response = new TimeStampResponse(timestampRes);
        response.validate(request);
        TimeStampToken token = response.getTimeStampToken();
        return token.getEncoded();
    }

    public static byte[] longTermValidation(byte[] pdfDocumentBytes, List<List<byte[]>> revInfos) throws Exception {
        ByteArrayOutputStream outputPDF = new ByteArrayOutputStream();
        PDDocument document = PDDocument.load((byte[])pdfDocumentBytes);
        COSDictionary catalogDict = document.getDocumentCatalog().getCOSObject();
        catalogDict.setNeedToBeUpdated(true);
        COSDictionary catalogDictItem = new COSDictionary();
        if (catalogDict.containsKey(COSName.getPDFName((String)"DSS"))) {
            catalogDictItem = (COSDictionary)catalogDict.getDictionaryObject(COSName.getPDFName((String)"DSS"));
        }
        COSDictionary dss = PdfSignature.createDssDictionary(revInfos.get(0), revInfos.get(2), revInfos.get(1), (COSDictionary)catalogDictItem);
        logger.info("revocation information embedded in PDF document");
        catalogDict.setItem(COSName.getPDFName((String)"DSS"), (COSBase)dss);
        document.saveIncremental((OutputStream)outputPDF);
        outputPDF.close();
        document.close();
        return outputPDF.toByteArray();
    }

    public static COSDictionary createDssDictionary(List<byte[]> certifiates, List<byte[]> crls, List<byte[]> ocspResponses, COSDictionary catalogDictItem) throws IOException {
        COSArray cosArrays;
        COSName key;
        COSDictionary dssDictionary = catalogDictItem == null ? new COSDictionary() : catalogDictItem;
        dssDictionary.setNeedToBeUpdated(true);
        dssDictionary.setName(COSName.TYPE, "DSS");
        if (certifiates.size() != 0) {
            key = COSName.getPDFName((String)"Certs");
            cosArrays = dssDictionary.containsKey(key) ? dssDictionary.getCOSArray(key) : new COSArray();
            dssDictionary.setItem(key, (COSBase)PdfSignature.createArray(certifiates, (COSArray)cosArrays));
        }
        if (crls.size() != 0) {
            key = COSName.getPDFName((String)"CRLs");
            cosArrays = dssDictionary.containsKey(key) ? dssDictionary.getCOSArray(key) : new COSArray();
            dssDictionary.setItem(key, (COSBase)PdfSignature.createArray(crls, (COSArray)cosArrays));
        }
        if (ocspResponses.size() != 0) {
            key = COSName.getPDFName((String)"OCSPs");
            cosArrays = dssDictionary.containsKey(key) ? dssDictionary.getCOSArray(key) : new COSArray();
            dssDictionary.setItem(key, (COSBase)PdfSignature.createArray(ocspResponses, (COSArray)cosArrays));
        }
        return dssDictionary;
    }

    public static COSArray createArray(List<byte[]> datas, COSArray cosArray) throws IOException {
        COSArray array = cosArray != null ? cosArray : new COSArray();
        array.setNeedToBeUpdated(true);
        if (datas != null) {
            for (byte[] data : datas) {
                array.add((COSBase)PdfSignature.createStream((byte[])data));
            }
        }
        return array;
    }

    public static COSStream createStream(byte[] data) throws IOException {
        COSStream stream = new COSStream();
        stream.setNeedToBeUpdated(true);
        OutputStream unfilteredStream = stream.createOutputStream((COSBase)COSName.FLATE_DECODE);
        unfilteredStream.write(data);
        unfilteredStream.flush();
        unfilteredStream.close();
        return stream;
    }

    public static List<List<byte[]>> getRevocationInformation(List<X509Certificate> signerCertChain) throws Exception {
        ArrayList<List<byte[]>> revInfo = new ArrayList<List<byte[]>>();
        ArrayList<byte[]> certList = new ArrayList<byte[]>();
        ArrayList<byte[]> crlList = new ArrayList<byte[]>();
        ArrayList<byte[]> ocspList = new ArrayList<byte[]>();
        for (int i = 0; i < signerCertChain.size() - 1; ++i) {
            byte[] cdpExtVal;
            String ocspResponderURL = null;
            String cdpURL = null;
            X509Certificate cert = signerCertChain.get(i);
            certList.add(cert.getEncoded());
            X509CertificateHolder issuer = new X509CertificateHolder(signerCertChain.get(i + 1).getEncoded());
            byte[] aiaExtVal = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (aiaExtVal != null) {
                ASN1InputStream ais1 = new ASN1InputStream((InputStream)new ByteArrayInputStream(aiaExtVal));
                DEROctetString oct = (DEROctetString)ais1.readObject();
                ASN1InputStream ais2 = new ASN1InputStream(oct.getOctets());
                AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)ais2.readObject());
                for (AccessDescription accessDescription : aia.getAccessDescriptions()) {
                    GeneralName gn;
                    if (!accessDescription.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.ocspAccessMethod) || (gn = accessDescription.getAccessLocation()).getTagNo() != 6) continue;
                    DERIA5String str = DERIA5String.getInstance((Object)gn.getName());
                    ocspResponderURL = str.getString();
                    logger.info("certificate from which OCSP URL is extracted: " + cert.getSubjectDN());
                    logger.info("OCSP responder URL from AIA: " + ocspResponderURL);
                }
            }
            if ((cdpExtVal = cert.getExtensionValue(Extension.cRLDistributionPoints.getId())) != null) {
                ASN1InputStream ais1 = new ASN1InputStream((InputStream)new ByteArrayInputStream(cdpExtVal));
                DEROctetString oct = (DEROctetString)ais1.readObject();
                ASN1InputStream ais2 = new ASN1InputStream(oct.getOctets());
                CRLDistPoint cdp = CRLDistPoint.getInstance((Object)ais2.readObject());
                for (DistributionPoint dp : cdp.getDistributionPoints()) {
                    GeneralName[] genNames;
                    DistributionPointName dpn = dp.getDistributionPoint();
                    if (dpn == null || dpn.getType() != 0) continue;
                    for (GeneralName genName : genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames()) {
                        if (genName.getTagNo() != 6) continue;
                        cdpURL = DERIA5String.getInstance((Object)genName.getName()).getString();
                        logger.info("certificate from which CDP URL is extracted: " + cert.getSubjectDN());
                        logger.info("CRL URL from CDP: " + cdpURL);
                    }
                }
            }
            if (cdpURL != null) {
                logger.info("Embedding CRL for cert: " + cert.getSubjectDN());
                HashMap reqHeaders = new HashMap();
                HTTPClient client = new HTTPClient(cdpURL, reqHeaders);
                client.sendGETRequest();
                byte[] crl = client.getBody();
                X509CRLHolder crlHolder = new X509CRLHolder(crl);
                if (crlHolder.getRevokedCertificate(cert.getSerialNumber()) != null) {
                    throw new Exception("certificate status in CRL is not GOOD");
                }
                crlList.add(crl);
                continue;
            }
            logger.info("Embedding OCSP response for cert: " + cert.getSubjectDN());
            DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
            CertificateID id = new CertificateID(digestCalculator, issuer, cert.getSerialNumber());
            byte[] nonce = new byte[16];
            Random rand = new Random();
            rand.nextBytes(nonce);
            OCSPReqBuilder generator = new OCSPReqBuilder();
            generator.addRequest(id);
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1Encodable)new DEROctetString(nonce));
            generator.setRequestExtensions(extGen.generate());
            byte[] ocspReq = generator.build().getEncoded();
            HashMap<String, String> reqHeaders = new HashMap<String, String>();
            reqHeaders.put("content-type", "application/ocsp-request");
            HTTPClient client = new HTTPClient(ocspResponderURL, reqHeaders);
            client.sendPOSTRequest(ocspReq);
            OCSPResp ocspRes = new OCSPResp(client.getBody());
            logger.info("OCSP response status: " + ocspRes.getStatus());
            if (ocspRes.getStatus() != 0) {
                throw new Exception("OCSP response status is not successful");
            }
            BasicOCSPResp basicOcsp = (BasicOCSPResp)ocspRes.getResponseObject();
            if (basicOcsp.getResponses()[0].getCertStatus() != null) {
                throw new Exception("certificate status in OCSP response is not GOOD");
            }
            ocspList.add(ocspRes.getEncoded());
        }
        revInfo.add(certList);
        revInfo.add(ocspList);
        revInfo.add(crlList);
        return revInfo;
    }

    public static byte[] timestampDocument(byte[] pdfDocBytes, String tsaUrl) throws Exception {
        PDDocument document;
        ByteArrayOutputStream outputPDF = new ByteArrayOutputStream();
        try {
            document = PDDocument.load((byte[])pdfDocBytes);
            document.setDocumentId(Long.valueOf(new Random().nextLong()));
        }
        catch (IOException ex) {
            throw new PdfException("invalid PDF format");
        }
        PDSignature signature = new PDSignature();
        signature.setType(COSName.DOC_TIME_STAMP);
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(COSName.getPDFName((String)"ETSI.RFC3161"));
        signature.setSignDate(Calendar.getInstance());
        SignatureOptions options = new SignatureOptions();
        document.addSignature(signature, options);
        ExternalSigningSupport externalSigning = document.saveIncrementalForExternalSigning((OutputStream)outputPDF);
        byte[] token = PdfSignature.signatureTimestamp((byte[])IOUtils.toByteArray((InputStream)externalSigning.getContent()), (String)tsaUrl);
        externalSigning.setSignature(token);
        IOUtils.close((Closeable)options);
        outputPDF.close();
        document.close();
        CMSSignedData data = new CMSSignedData(token);
        TimeStampToken timeToken = new TimeStampToken(data);
        Store certificatesStore = timeToken.getCertificates();
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509CertificateHolder certHolder : certificatesStore.getMatches(null)) {
            certs.add(new JcaX509CertificateConverter().getCertificate(certHolder));
        }
        X509Certificate lastCertificate = (X509Certificate)certs.get(certs.size() - 1);
        if (!lastCertificate.getSubjectDN().equals(lastCertificate.getIssuerDN())) {
            X509Certificate issuerCertificate = PdfSignature.getIssuerCertificate((X509Certificate)lastCertificate);
            certs.add(issuerCertificate);
        }
        List revInfos = PdfSignature.getRevocationInformation(certs);
        return PdfSignature.longTermValidation((byte[])outputPDF.toByteArray(), (List)revInfos);
    }

    public static X509Certificate getIssuerCertificate(X509Certificate certificate) throws Exception {
        logger.info("Get Issuer CA for cert: " + certificate.getSubjectDN());
        HashMap reqHeaders = new HashMap();
        String issuerURL = PdfSignature.getAuthorityInformationAccess((X509Certificate)certificate);
        HTTPClient client = new HTTPClient(issuerURL, reqHeaders);
        client.sendGETRequest();
        byte[] issuerCertBytes = client.getBody();
        return new JcaX509CertificateConverter().getCertificate(new X509CertificateHolder(issuerCertBytes));
    }

    public static String getAuthorityInformationAccess(X509Certificate certificate) throws IOException {
        byte[] aiaExtVal = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (aiaExtVal != null) {
            ASN1InputStream ais1 = new ASN1InputStream((InputStream)new ByteArrayInputStream(aiaExtVal));
            DEROctetString oct = (DEROctetString)ais1.readObject();
            ASN1InputStream ais2 = new ASN1InputStream(oct.getOctets());
            AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)ais2.readObject());
            for (AccessDescription accessDescription : aia.getAccessDescriptions()) {
                GeneralName gn;
                if (!accessDescription.getAccessMethod().equals((ASN1Primitive)X509ObjectIdentifiers.id_ad_caIssuers) || (gn = accessDescription.getAccessLocation()).getTagNo() != 6) continue;
                ASN1IA5String str = ASN1IA5String.getInstance((Object)gn.getName());
                String caIssuerURL = str.getString();
                logger.info("certificate from which CA Issuer URL is extracted: " + certificate.getSubjectDN());
                logger.info("CA Issuer URL from AIA: " + caIssuerURL);
                return caIssuerURL;
            }
        }
        return "";
    }
}

