/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.document.signing.gateway.http;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HTTPClient {
    private String url;
    private Map<String, String> reqHeaders;
    private byte[] body;
    private String contentType;
    private int status;
    private Map<String, String> responseHeaders;

    public HTTPClient(String url, Map<String, String> reqHeaders) {
        this.url = url;
        this.reqHeaders = reqHeaders;
    }

    public void sendGETRequest() throws Exception {
        HttpGet request = new HttpGet(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(120000).setConnectTimeout(120000).setSocketTimeout(120000).build();
        request.setConfig(requestConfig);
        for (Map.Entry entry : this.reqHeaders.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            this.responseHeaders = new HashMap();
            for (Header resHeader : response.getAllHeaders()) {
                this.responseHeaders.put(resHeader.getName(), resHeader.getValue());
            }
            this.status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                this.contentType = entity.getContentType().getValue();
                this.body = IOUtils.toByteArray((InputStream)entity.getContent());
            }
        }
    }

    public void sendPOSTRequest(byte[] requestBody) throws Exception {
        HttpPost request = new HttpPost(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(120000).setConnectTimeout(120000).setSocketTimeout(120000).build();
        request.setConfig(requestConfig);
        for (Map.Entry entry : this.reqHeaders.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        request.setEntity((HttpEntity)new ByteArrayEntity(requestBody));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            this.responseHeaders = new HashMap();
            for (Header resHeader : response.getAllHeaders()) {
                this.responseHeaders.put(resHeader.getName(), resHeader.getValue());
            }
            this.status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                this.contentType = entity.getContentType().getValue();
                this.body = IOUtils.toByteArray((InputStream)entity.getContent());
            }
        }
    }

    public void sendDELETERequest() throws Exception {
        HttpDelete request = new HttpDelete(this.url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(120000).setConnectTimeout(120000).setSocketTimeout(120000).build();
        request.setConfig(requestConfig);
        for (Map.Entry entry : this.reqHeaders.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            this.responseHeaders = new HashMap();
            for (Header resHeader : response.getAllHeaders()) {
                this.responseHeaders.put(resHeader.getName(), resHeader.getValue());
            }
            this.status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                this.contentType = entity.getContentType().getValue();
                this.body = IOUtils.toByteArray((InputStream)entity.getContent());
            }
        }
    }

    public byte[] getBody() {
        return this.body;
    }

    public int getHttpStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

