/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.AccessTokenException;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.util.AccessToken;
import com.ssl.doc.signing.tool.util.Paths;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="get_credential_ids", description={"Returns list of credential IDs associated with the user"}, version={"v1.3.0"}, mixinStandardHelpOptions=true)
public class CredentialsIDCommand
implements Runnable {
    private static final Logger logger = LogManager.getLogger(CredentialsIDCommand.class);
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;

    @Override
    public void run() {
        try {
            logger.info("Command: get_credential_ids");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            String[] dsCredentialIds = cscApi.getCredentialIDs("DS");
            String[] esealCredentialIds = cscApi.getCredentialIDs("DS_ESEAL");
            System.out.println("Document Signing Credential ID(s): ");
            for (String credId : dsCredentialIds) {
                logger.info("Credential ID: " + credId);
                System.out.println("- " + credId);
            }
            System.out.println("Document Sealing Credential ID(s): ");
            for (String credId : esealCredentialIds) {
                logger.info("Credential ID: " + credId);
                System.out.println("- " + credId);
            }
            logger.info("get_credential_ids command executed successfully");
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }
}

