/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.CodepointsUtil;
import org.apache.poi.util.Removal;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public class SheetDataWriter
implements Closeable {
    private static final Logger LOG = LogManager.getLogger(SheetDataWriter.class);
    private final File _fd;
    protected final Writer _out;
    private int _rownum;
    private int _numberOfFlushedRows;
    private int _lowestIndexOfFlushedRows;
    private int _numberOfCellsOfLastFlushedRow;
    private int _numberLastFlushedRow = -1;
    private SharedStringsTable _sharedStringSource;

    public SheetDataWriter() throws IOException {
        this._fd = this.createTempFile();
        this._out = this.createWriter(this._fd);
    }

    public SheetDataWriter(Writer writer) throws IOException {
        this._fd = null;
        this._out = writer;
    }

    public SheetDataWriter(SharedStringsTable sharedStringsTable) throws IOException {
        this();
        this._sharedStringSource = sharedStringsTable;
    }

    @Removal(version="6.0.0")
    public File createTempFile() throws IOException {
        return TempFile.createTempFile("poi-sxssf-sheet", ".xml");
    }

    @Removal(version="6.0.0")
    public Writer createWriter(File fd) throws IOException {
        OutputStream decorated;
        FileOutputStream fos = new FileOutputStream(fd);
        try {
            decorated = this.decorateOutputStream(fos);
        }
        catch (IOException e) {
            fos.close();
            throw e;
        }
        return new BufferedWriter(new OutputStreamWriter(decorated, StandardCharsets.UTF_8));
    }

    protected OutputStream decorateOutputStream(FileOutputStream fos) throws IOException {
        return fos;
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    protected File getTempFile() {
        return this._fd;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File fd = this.getTempFile();
        if (fd == null) {
            throw new IOException("getWorksheetXMLInputStream only works when a temp file is used");
        }
        FileInputStream fis = new FileInputStream(fd);
        try {
            return this.decorateInputStream(fis);
        }
        catch (IOException e) {
            fis.close();
            throw e;
        }
    }

    protected InputStream decorateInputStream(FileInputStream fis) throws IOException {
        return fis;
    }

    public int getNumberOfFlushedRows() {
        return this._numberOfFlushedRows;
    }

    public int getNumberOfCellsOfLastFlushedRow() {
        return this._numberOfCellsOfLastFlushedRow;
    }

    public int getLowestIndexOfFlushedRows() {
        return this._lowestIndexOfFlushedRows;
    }

    public int getLastFlushedRow() {
        return this._numberLastFlushedRow;
    }

    public void writeRow(int rownum, SXSSFRow row) throws IOException {
        if (this._numberOfFlushedRows == 0) {
            this._lowestIndexOfFlushedRows = rownum;
        }
        this._numberLastFlushedRow = Math.max(rownum, this._numberLastFlushedRow);
        this._numberOfCellsOfLastFlushedRow = row.getLastCellNum();
        ++this._numberOfFlushedRows;
        this.beginRow(rownum, row);
        Iterator<Cell> cells = row.allCellsIterator();
        int columnIndex = 0;
        while (cells.hasNext()) {
            this.writeCell(columnIndex++, cells.next());
        }
        this.endRow();
    }

    void beginRow(int rownum, SXSSFRow row) throws IOException {
        this._out.write("<row");
        this.writeAttribute("r", Integer.toString(rownum + 1));
        if (row.hasCustomHeight()) {
            this.writeAttribute("customHeight", "true");
            this.writeAttribute("ht", Float.toString(row.getHeightInPoints()));
        }
        if (row.getZeroHeight()) {
            this.writeAttribute("hidden", "true");
        }
        if (row.isFormatted()) {
            this.writeAttribute("s", Integer.toString(row.getRowStyleIndex()));
            this.writeAttribute("customFormat", "1");
        }
        if (row.getOutlineLevel() != 0) {
            this.writeAttribute("outlineLevel", Integer.toString(row.getOutlineLevel()));
        }
        if (row.getHidden() != null) {
            this.writeAttribute("hidden", row.getHidden() != false ? "1" : "0");
        }
        if (row.getCollapsed() != null) {
            this.writeAttribute("collapsed", row.getCollapsed() != false ? "1" : "0");
        }
        this._out.write(">\n");
        this._rownum = rownum;
    }

    void endRow() throws IOException {
        this._out.write("</row>\n");
    }

    public void writeCell(int columnIndex, Cell cell) throws IOException {
        if (cell == null) {
            return;
        }
        String ref = new CellReference(this._rownum, columnIndex).formatAsString();
        this._out.write("<c");
        this.writeAttribute("r", ref);
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle.getIndex() != 0) {
            this.writeAttribute("s", Integer.toString(cellStyle.getIndex() & 0xFFFF));
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BLANK: {
                this._out.write(62);
                break;
            }
            case FORMULA: {
                switch (cell.getCachedFormulaResultType()) {
                    case NUMERIC: {
                        this.writeAttribute("t", "n");
                        break;
                    }
                    case STRING: {
                        this.writeAttribute("t", STCellType.STR.toString());
                        break;
                    }
                    case BOOLEAN: {
                        this.writeAttribute("t", "b");
                        break;
                    }
                    case ERROR: {
                        this.writeAttribute("t", "e");
                    }
                }
                this._out.write("><f>");
                this.outputEscapedString(cell.getCellFormula());
                this._out.write("</f>");
                switch (cell.getCachedFormulaResultType()) {
                    case NUMERIC: {
                        double nval = cell.getNumericCellValue();
                        if (Double.isNaN(nval)) break;
                        this._out.write("<v>");
                        this._out.write(Double.toString(nval));
                        this._out.write("</v>");
                        break;
                    }
                    case STRING: {
                        String value = cell.getStringCellValue();
                        if (value == null || value.isEmpty()) break;
                        this._out.write("<v>");
                        this.outputEscapedString(value);
                        this._out.write("</v>");
                        break;
                    }
                    case BOOLEAN: {
                        this._out.write("><v>");
                        this._out.write(cell.getBooleanCellValue() ? "1" : "0");
                        this._out.write("</v>");
                        break;
                    }
                    case ERROR: {
                        FormulaError error = FormulaError.forInt(cell.getErrorCellValue());
                        this._out.write("><v>");
                        this.outputEscapedString(error.getString());
                        this._out.write("</v>");
                        break;
                    }
                }
                break;
            }
            case STRING: {
                if (this._sharedStringSource != null) {
                    RichTextString rt = cell.getRichStringCellValue();
                    int sRef = this._sharedStringSource.addSharedStringItem(rt);
                    this.writeAttribute("t", STCellType.S.toString());
                    this._out.write("><v>");
                    this._out.write(String.valueOf(sRef));
                    this._out.write("</v>");
                    break;
                }
                this.writeAttribute("t", "inlineStr");
                this._out.write("><is><t");
                if (this.hasLeadingTrailingSpaces(cell.getStringCellValue())) {
                    this.writeAttribute("xml:space", "preserve");
                }
                this._out.write(">");
                this.outputEscapedString(cell.getStringCellValue());
                this._out.write("</t></is>");
                break;
            }
            case NUMERIC: {
                this.writeAttribute("t", "n");
                this._out.write("><v>");
                this._out.write(Double.toString(cell.getNumericCellValue()));
                this._out.write("</v>");
                break;
            }
            case BOOLEAN: {
                this.writeAttribute("t", "b");
                this._out.write("><v>");
                this._out.write(cell.getBooleanCellValue() ? "1" : "0");
                this._out.write("</v>");
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt(cell.getErrorCellValue());
                this.writeAttribute("t", "e");
                this._out.write("><v>");
                this.outputEscapedString(error.getString());
                this._out.write("</v>");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid cell type: " + cellType);
            }
        }
        this._out.write("</c>");
    }

    private void writeAttribute(String name, String value) throws IOException {
        this._out.write(32);
        this._out.write(name);
        this._out.write("=\"");
        this._out.write(value);
        this._out.write(34);
    }

    boolean hasLeadingTrailingSpaces(String str) {
        if (str != null && str.length() > 0) {
            char firstChar = str.charAt(0);
            char lastChar = str.charAt(str.length() - 1);
            return Character.isWhitespace(firstChar) || Character.isWhitespace(lastChar);
        }
        return false;
    }

    protected void outputEscapedString(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return;
        }
        PrimitiveIterator.OfInt iter = CodepointsUtil.primitiveIterator(s);
        block10: while (iter.hasNext()) {
            int codepoint = iter.nextInt();
            switch (codepoint) {
                case 60: {
                    this._out.write("&lt;");
                    continue block10;
                }
                case 62: {
                    this._out.write("&gt;");
                    continue block10;
                }
                case 38: {
                    this._out.write("&amp;");
                    continue block10;
                }
                case 34: {
                    this._out.write("&quot;");
                    continue block10;
                }
                case 10: {
                    this._out.write("&#xa;");
                    continue block10;
                }
                case 13: {
                    this._out.write("&#xd;");
                    continue block10;
                }
                case 9: {
                    this._out.write("&#x9;");
                    continue block10;
                }
                case 160: {
                    this._out.write("&#xa0;");
                    continue block10;
                }
            }
            char[] chars = Character.toChars(codepoint);
            if (chars.length == 1) {
                char c = chars[0];
                if (SheetDataWriter.replaceWithQuestionMark(c)) {
                    this._out.write(63);
                    continue;
                }
                this._out.write(c);
                continue;
            }
            this._out.write(chars);
        }
    }

    static boolean replaceWithQuestionMark(char c) {
        return c < ' ' || '\ufffe' <= c && c <= '\uffff';
    }

    void flush() throws IOException {
        this._out.flush();
    }

    boolean dispose() throws IOException {
        boolean ret;
        try {
            this._out.close();
        }
        finally {
            ret = this._fd.delete();
        }
        return ret;
    }
}

