/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.csc.CredentialInfo;
import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.util.AccessToken;
import com.ssl.doc.signing.tool.util.Paths;
import de.taimos.totp.TOTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="sign_hash", description={"Sign the hash(es)"}, version={"v1.3.0"}, mixinStandardHelpOptions=true)
public class SignHashCommand
implements Runnable {
    private static final Logger logger = LogManager.getLogger(SignHashCommand.class);
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=false)
    private String credentialId;
    @CommandLine.Option(names={"-hash"}, description={"Comma separated base64 encoded hash(es) to sign"}, required=true)
    private String hash;
    @CommandLine.Option(names={"-totp_secret"}, description={"TOTP secret"}, required=false)
    private String totpSecret;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where comma separated signature values will be written"}, required=true)
    private String outputDirPath;

    @Override
    public void run() {
        try {
            logger.info("Command: sign hash");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            File outputDir = new File(this.outputDirPath);
            if (!outputDir.isDirectory()) {
                logger.info("Not a valid output directory: " + this.outputDirPath);
                System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                return;
            }
            logger.info("Output directory path: " + outputDir);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            CredentialInfo credentialInfo = cscApi.getCredentialInfo(this.credentialId);
            String[] credentialIds = null;
            boolean isDocSigningCert = true;
            String[] dsCredentialIds = cscApi.getCredentialIDs("DS");
            String[] esealCredentialIds = cscApi.getCredentialIDs("DS_ESEAL");
            if (this.credentialId != null && !this.credentialId.equals("")) {
                logger.info("Credential ID in input parameter: " + this.credentialId);
                List<String> credentialList = Arrays.asList(dsCredentialIds);
                if (credentialList.contains(this.credentialId)) {
                    isDocSigningCert = true;
                } else {
                    credentialList = Arrays.asList(esealCredentialIds);
                    if (credentialList.contains(this.credentialId)) {
                        isDocSigningCert = false;
                    } else {
                        logger.info("invalid credential_id in request: " + this.credentialId);
                        System.out.print("Error: Invalid credential_id in request: " + this.credentialId);
                        return;
                    }
                }
                credentialIds = new String[]{this.credentialId};
            } else {
                logger.info("No credential ID provided in input parameter");
                credentialIds = (String[])Stream.concat(Arrays.stream(dsCredentialIds), Arrays.stream(esealCredentialIds)).toArray(String[]::new);
                if (credentialIds.length == 0) {
                    logger.info("No credential ID found for this user");
                    System.out.print("Error: No credential ID found for this user");
                    return;
                }
                if (credentialIds.length > 1) {
                    System.out.println("Multiple valid credential IDs are available for this user. Please use the '-credential_id' option to designate which certificate to use for signing. Please use the 'credential_info' command to obtain more details about each credential ID");
                    System.out.println("Document Signing Credential ID(s): ");
                    for (String credId : dsCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                    System.out.println("Document seal Credential ID(s): ");
                    for (String credId : esealCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                    return;
                }
                if (credentialIds.length == 1 && dsCredentialIds.length == 1) {
                    isDocSigningCert = true;
                } else if (credentialIds.length == 1 && esealCredentialIds.length == 1) {
                    isDocSigningCert = false;
                }
            }
            this.credentialId = credentialIds[0];
            logger.info("Credential ID retrieved from signatures service: " + this.credentialId);
            String otp = null;
            if (isDocSigningCert) {
                if (this.totpSecret == null || this.totpSecret.equals("")) {
                    System.out.print("Enter the OTP - Press enter to continue: ");
                    Scanner otpInput = new Scanner(System.in);
                    otp = otpInput.nextLine();
                    if (otp == null || otp.equals("")) {
                        System.out.print("Error: OTP not provided");
                        return;
                    }
                } else {
                    byte[] totpSeed = Base64.getDecoder().decode(this.totpSecret);
                    String hexKey = Hex.encodeHexString(totpSeed);
                    otp = TOTP.getOTP(hexKey);
                }
            } else {
                if (this.totpSecret != null) {
                    logger.info("TOTP secret must not be present for eseal");
                    System.out.print("Error: TOTP secret must not be present for eseal");
                    return;
                }
                if (otp != null) {
                    logger.info("OTP must not be present for eseal");
                    System.out.print("Error: OTP must not be present for eseal");
                    return;
                }
            }
            String[] hashes = this.hash.split(",");
            String sad = cscApi.getCredentialsAuthorize(this.credentialId, hashes.length, hashes, otp);
            String[] signatures = cscApi.signHash(this.credentialId, sad, hashes, credentialInfo.getSignatureAlgorithm());
            StringBuilder sigs = new StringBuilder();
            for (int i = 0; i < signatures.length; ++i) {
                sigs.append(signatures[i]);
                if (i == signatures.length - 1) continue;
                sigs.append(",");
            }
            FileOutputStream out = new FileOutputStream(this.outputDirPath + File.separator + "signatures.sig");
            out.write(sigs.toString().getBytes());
            out.close();
            System.out.println("Sign hash(es) command executed successfully. Signatures file is created at: " + this.outputDirPath + File.separator + "signatures.sig");
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }
}

