/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.exception.AccessTokenException;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.pdf.PdfSignature;
import com.ssl.doc.signing.tool.util.AccessToken;
import com.ssl.doc.signing.tool.util.Paths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="timestamp", description={"Timestamp PDF document"}, version={"v1.3.0"}, mixinStandardHelpOptions=true)
public class TimestampCommand
implements Runnable {
    private static final Logger logger = LogManager.getLogger(TimestampCommand.class);
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-input_file_path"}, description={"Path of the document to be signed"}, required=true)
    private String inputFilePath;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where signed document will be written"}, required=false)
    private String outputDirPath;
    @CommandLine.Option(names={"-override"}, description={"Overrides the input file after signing, if this parameter is set and no -output_dir_path parameter"}, required=false)
    private boolean override;

    @Override
    public void run() {
        try {
            File inputFile;
            logger.info("Command: timestamp");
            Properties props = new Properties();
            props.load(new FileInputStream(Paths.getConfigFilePath()));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            String tsaUrl = props.getProperty("TSA_URL");
            logger.info("TSA URL: " + tsaUrl);
            if (this.outputDirPath == null || this.outputDirPath.equals("")) {
                if (!this.override) {
                    logger.info("'-output_directory' parameter is not set. The output signed file will replace the original file. Do you still want to continue [y/n]? ");
                    System.out.print("Warn: '-output_directory' parameter is not set. The output signed file will replace the original file. Do you still want to continue [y/n]? ");
                    Scanner sc = new Scanner(System.in);
                    String yesOrNo = sc.nextLine();
                    logger.info("User selected: " + yesOrNo);
                    if (yesOrNo.equalsIgnoreCase("n")) {
                        return;
                    }
                    if (!yesOrNo.equalsIgnoreCase("y")) {
                        System.out.print("Error: Possible value is y/n");
                        return;
                    }
                }
            } else {
                File outputDir = new File(this.outputDirPath);
                if (!outputDir.isDirectory()) {
                    logger.info("Not a valid output directory: " + this.outputDirPath);
                    System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                    return;
                }
                logger.info("Output directory path: " + outputDir);
            }
            if (!(inputFile = new File(this.inputFilePath)).exists()) {
                logger.info("Invalid input file path: " + inputFile);
                System.out.print("Error: Invalid input file path - " + inputFile);
                return;
            }
            logger.info("Input file path: " + this.inputFilePath);
            String docType = "pdf";
            String ext = FilenameUtils.getExtension(this.inputFilePath);
            if (!ext.equals("pdf")) {
                logger.info("only PDF documents are allowed");
                System.out.print("Error: only PDF documents are allowed");
                return;
            }
            logger.info("File type: " + ext);
            logger.info("Document type: " + docType);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            accessTokenObj.getAccessToken();
            byte[] timestampDocument = PdfSignature.timestampDocument(inputFile, tsaUrl);
            if (this.outputDirPath != null) {
                FileOutputStream fout = new FileOutputStream(this.outputDirPath + File.separator + inputFile.getName());
                fout.write(timestampDocument);
                fout.close();
                System.out.println("Document timestamped successfully: " + this.outputDirPath + File.separator + inputFile.getName());
            } else {
                FileOutputStream fout = new FileOutputStream(this.inputFilePath);
                fout.write(timestampDocument);
                fout.close();
                System.out.println("Document timestamped successfully: " + this.inputFilePath);
            }
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }
}

