/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.document.signing.security;

import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import org.apache.poi.poifs.crypt.dsig.SignatureAlg;
import org.apache.poi.poifs.crypt.dsig.SignatureMethod;

public class DummyPrivateKey {
    private static PrivateKey RSA_PRIVATE_KEY;
    private static PrivateKey ECDSA_PRIVATE_KEY;

    public static PrivateKey Key(SignatureMethod signatureMethod) throws NoSuchAlgorithmException {
        return signatureMethod.getName().equals(SignatureAlg.RSA) ? DummyPrivateKey.RSAKey() : DummyPrivateKey.ECDSAKey();
    }

    public static PrivateKey ECDSAKey() throws NoSuchAlgorithmException {
        if (ECDSA_PRIVATE_KEY == null) {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            ECDSA_PRIVATE_KEY = generator.generateKeyPair().getPrivate();
        }
        return ECDSA_PRIVATE_KEY;
    }

    public static PrivateKey RSAKey() throws NoSuchAlgorithmException {
        if (RSA_PRIVATE_KEY == null) {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            RSA_PRIVATE_KEY = generator.generateKeyPair().getPrivate();
        }
        return RSA_PRIVATE_KEY;
    }
}

