/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawerDefaultFonts;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class PdfBoxGraphics2DFontTextDrawer
implements IPdfBoxGraphics2DFontTextDrawer,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(PdfBoxGraphics2DFontTextDrawer.class.getName());
    private final List<FontEntry> fontFiles = new ArrayList<FontEntry>();
    private final List<File> tempFiles = new ArrayList<File>();
    private final Map<String, PDFont> fontMap = new HashMap<String, PDFont>();
    private PDFont fallbackFontUnknownEncodings;
    private static final boolean DEBUG_BOX = false;

    @Override
    public void close() {
        for (File tempFile : this.tempFiles) {
            tempFile.delete();
        }
        this.tempFiles.clear();
        this.fontFiles.clear();
        this.fontMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFont(String fontName, InputStream fontStream) throws IOException {
        File fontFile = File.createTempFile("pdfboxgfx2dfont", ".ttf");
        FileOutputStream out = new FileOutputStream(fontFile);
        try {
            IOUtils.copy(fontStream, out);
        }
        finally {
            out.close();
        }
        fontFile.deleteOnExit();
        this.tempFiles.add(fontFile);
        this.registerFont(fontName, fontFile);
    }

    public void registerFont(String fontName, File fontFile) {
        if (!fontFile.exists()) {
            throw new IllegalArgumentException("Font " + fontFile + " does not exist!");
        }
        FontEntry entry = new FontEntry();
        entry.overrideName = fontName;
        entry.file = fontFile;
        this.fontFiles.add(entry);
    }

    public void registerFont(File fontFile) {
        this.registerFont(null, fontFile);
    }

    public void registerFont(InputStream fontStream) throws IOException {
        this.registerFont(null, fontStream);
    }

    public void registerFont(String name, PDFont font) {
        this.fontMap.put(name, font);
    }

    protected boolean hasDynamicFontMapping() {
        return this.getClass() != PdfBoxGraphics2DFontTextDrawer.class;
    }

    @Override
    public boolean canDrawText(AttributedCharacterIterator iterator, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        if (this.fontMap.size() == 0 && this.fontFiles.size() == 0 && !this.hasDynamicFontMapping()) {
            return false;
        }
        boolean run = true;
        StringBuilder sb = new StringBuilder();
        while (run) {
            int codePoint;
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            if (attributeFont == null) {
                attributeFont = env.getFont();
            }
            if (this.mapFont(attributeFont, env) == null) {
                return false;
            }
            if (iterator.getAttribute(TextAttribute.BACKGROUND) != null) {
                return false;
            }
            boolean isLigatures = TextAttribute.LIGATURES_ON.equals(iterator.getAttribute(TextAttribute.LIGATURES));
            if (isLigatures) {
                return false;
            }
            run = this.iterateRun(iterator, sb);
            String s = sb.toString();
            int l = s.length();
            for (int i = 0; i < l; i += Character.charCount(codePoint)) {
                codePoint = s.codePointAt(i);
                switch (Character.getDirectionality(codePoint)) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 16: 
                    case 17: 
                    case 18: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (attributeFont.canDisplay(codePoint)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void drawText(AttributedCharacterIterator iterator, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDPageContentStream contentStream = env.getContentStream();
        DrawTextDecorationState drawState = new DrawTextDecorationState(contentStream);
        contentStream.saveGraphicsState();
        contentStream.beginText();
        AffineTransform identityTextMatrix = new AffineTransform();
        identityTextMatrix.scale(1.0, -1.0);
        boolean needMatrixResetToIdentity = true;
        drawState.currentPoint = new Point2D.Float(0.0f, 0.0f);
        StringBuilder sb = new StringBuilder();
        drawState.currentMatrix = null;
        boolean run = true;
        while (run) {
            Number fontSize;
            boolean wasAttributeFont;
            Font attributeFont = (Font)iterator.getAttribute(TextAttribute.FONT);
            boolean bl = wasAttributeFont = attributeFont != null;
            if (attributeFont == null) {
                attributeFont = env.getFont();
            }
            if ((fontSize = (Number)iterator.getAttribute(TextAttribute.SIZE)) != null) {
                attributeFont = attributeFont.deriveFont(fontSize.floatValue());
            }
            PDFont font = this.applyFont(attributeFont, env);
            Object transform = iterator.getAttribute(TextAttribute.TRANSFORM);
            AffineTransform attributedTransform = null;
            if (transform instanceof AffineTransform) {
                attributedTransform = (AffineTransform)transform;
            }
            if (transform instanceof TransformAttribute) {
                attributedTransform = ((TransformAttribute)transform).getTransform();
            }
            boolean attributeFontTransformed = attributeFont.isTransformed();
            if (attributedTransform != null && !wasAttributeFont || attributeFontTransformed) {
                AffineTransform tf = attributeFontTransformed ? attributeFont.getTransform() : attributedTransform;
                AffineTransform newAT = AffineTransform.getTranslateInstance(drawState.currentPoint.getX(), drawState.currentPoint.getY());
                newAT.concatenate(tf);
                newAT.scale(1.0, -1.0);
                drawState.setCurrentTextMatrix(newAT);
                needMatrixResetToIdentity = true;
            } else if (needMatrixResetToIdentity) {
                AffineTransform at = AffineTransform.getTranslateInstance(drawState.currentPoint.getX(), drawState.currentPoint.getY());
                at.scale(1.0, -1.0);
                drawState.setCurrentTextMatrix(at);
                needMatrixResetToIdentity = false;
            }
            Paint paint = (Paint)iterator.getAttribute(TextAttribute.FOREGROUND);
            if (paint == null) {
                paint = env.getPaint();
            }
            boolean isStrikeThrough = TextAttribute.STRIKETHROUGH_ON.equals(iterator.getAttribute(TextAttribute.STRIKETHROUGH));
            boolean isUnderline = TextAttribute.UNDERLINE_ON.equals(iterator.getAttribute(TextAttribute.UNDERLINE));
            boolean isLigatures = TextAttribute.LIGATURES_ON.equals(iterator.getAttribute(TextAttribute.LIGATURES));
            run = this.iterateRun(iterator, sb);
            String text = sb.toString();
            env.applyPaint(paint, null);
            try {
                this.showTextOnStream(env, attributeFont, font, isStrikeThrough, isUnderline, isLigatures, drawState, paint, text);
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException iae = e;
                if (font instanceof PDType1Font && !font.isEmbedded()) {
                    try {
                        if (this.fallbackFontUnknownEncodings == null) {
                            this.fallbackFontUnknownEncodings = this.findFallbackFont(env);
                        }
                        if (this.fallbackFontUnknownEncodings != null) {
                            env.getContentStream().setFont(this.fallbackFontUnknownEncodings, attributeFont.getSize2D());
                            this.showTextOnStream(env, attributeFont, this.fallbackFontUnknownEncodings, isStrikeThrough, isUnderline, isLigatures, drawState, paint, text);
                            iae = null;
                        }
                    }
                    catch (IllegalArgumentException e1) {
                        iae = e1;
                    }
                }
                if (iae == null) continue;
                LOGGER.log(Level.SEVERE, "PDFBoxGraphics: Can not map text " + text + " with font " + attributeFont.getFontName() + ": " + iae.getMessage(), iae);
            }
        }
        contentStream.endText();
        contentStream.restoreGraphicsState();
        if (!drawState.drawers.isEmpty()) {
            for (ITextDecorationDrawer drawer : drawState.drawers) {
                contentStream.saveGraphicsState();
                drawer.draw(contentStream);
                contentStream.restoreGraphicsState();
            }
        }
    }

    @Override
    public FontMetrics getFontMetrics(final Font f, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        final FontMetrics defaultMetrics = env.getCalculationGraphics().getFontMetrics(f);
        final PDFont pdFont = this.mapFont(f, env);
        if (pdFont == null) {
            return defaultMetrics;
        }
        return new FontMetrics(f){

            @Override
            public int getDescent() {
                return defaultMetrics.getDescent();
            }

            @Override
            public int getHeight() {
                return defaultMetrics.getHeight();
            }

            @Override
            public int getMaxAscent() {
                return defaultMetrics.getMaxAscent();
            }

            @Override
            public int getMaxDescent() {
                return defaultMetrics.getMaxDescent();
            }

            @Override
            public boolean hasUniformLineMetrics() {
                return defaultMetrics.hasUniformLineMetrics();
            }

            @Override
            public LineMetrics getLineMetrics(String str, Graphics context) {
                return defaultMetrics.getLineMetrics(str, context);
            }

            @Override
            public LineMetrics getLineMetrics(String str, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getLineMetrics(str, beginIndex, limit, context);
            }

            @Override
            public LineMetrics getLineMetrics(char[] chars, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getLineMetrics(chars, beginIndex, limit, context);
            }

            @Override
            public LineMetrics getLineMetrics(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getLineMetrics(ci, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getStringBounds(String str, Graphics context) {
                return defaultMetrics.getStringBounds(str, context);
            }

            @Override
            public Rectangle2D getStringBounds(String str, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getStringBounds(str, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getStringBounds(char[] chars, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getStringBounds(chars, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getStringBounds(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
                return defaultMetrics.getStringBounds(ci, beginIndex, limit, context);
            }

            @Override
            public Rectangle2D getMaxCharBounds(Graphics context) {
                return defaultMetrics.getMaxCharBounds(context);
            }

            @Override
            public int getAscent() {
                return defaultMetrics.getAscent();
            }

            @Override
            public int getMaxAdvance() {
                return defaultMetrics.getMaxAdvance();
            }

            @Override
            public int getLeading() {
                return defaultMetrics.getLeading();
            }

            @Override
            public FontRenderContext getFontRenderContext() {
                return defaultMetrics.getFontRenderContext();
            }

            @Override
            public int charWidth(char ch) {
                char[] chars = new char[]{ch};
                return this.charsWidth(chars, 0, chars.length);
            }

            @Override
            public int charWidth(int codePoint) {
                char[] data = Character.toChars(codePoint);
                return this.charsWidth(data, 0, data.length);
            }

            @Override
            public int charsWidth(char[] data, int off, int len) {
                return this.stringWidth(new String(data, off, len));
            }

            @Override
            public int stringWidth(String str) {
                try {
                    float width = pdFont.getStringWidth(str) / 1000.0f * f.getSize2D();
                    return (int)(width + 0.5f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    return defaultMetrics.stringWidth(str);
                }
            }

            @Override
            public int[] getWidths() {
                try {
                    int[] first256Widths = new int[256];
                    for (int i = 0; i < first256Widths.length; ++i) {
                        first256Widths[i] = (int)(pdFont.getWidth(i) / 1000.0f * (float)f.getSize());
                    }
                    return first256Widths;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private PDFont findFallbackFont(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException {
        String javaHome = System.getProperty("java.home", ".");
        String javaFontDir = javaHome + "/lib/fonts";
        String windir = System.getenv("WINDIR");
        if (windir == null) {
            windir = javaFontDir;
        }
        File[] paths = new File[]{new File(new File(windir), "fonts"), new File(System.getProperty("user.dir", ".")), new File("/Library/Fonts"), new File("/System/Library/Fonts/Supplemental/"), new File("/usr/share/fonts/truetype"), new File("/usr/share/fonts/truetype/dejavu"), new File("/usr/share/fonts/truetype/liberation"), new File("/usr/share/fonts/truetype/noto"), new File(javaFontDir)};
        for (String fontFileName : new String[]{"LucidaSansRegular.ttf", "arial.ttf", "Arial.ttf", "DejaVuSans.ttf", "LiberationMono-Regular.ttf", "NotoSerif-Regular.ttf", "Arial Unicode.ttf", "Tahoma.ttf"}) {
            for (File path : paths) {
                PDType0Font pdType0Font;
                File arialFile = new File(path, fontFileName);
                if (!arialFile.exists() || (pdType0Font = this.tryToLoadFont(env, arialFile)) == null) continue;
                return pdType0Font;
            }
        }
        return null;
    }

    private PDType0Font tryToLoadFont(IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env, File foundFontFile) {
        try {
            return PDType0Font.load(env.getDocument(), foundFontFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void showTextOnStream(final IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env, final Font attributeFont, final PDFont font, final boolean isStrikeThrough, final boolean isUnderline, boolean isLigatures, DrawTextDecorationState drawState, final Paint paint, String text) throws IOException {
        if (isLigatures) {
            // empty if block
        }
        final PDPageContentStream contentStream = drawState.contentStream;
        contentStream.showText(text);
        final float stringWidth = font.getStringWidth(text) / 1000.0f * attributeFont.getSize2D();
        if (isStrikeThrough || isUnderline) {
            final LineMetrics lineMetrics = attributeFont.getLineMetrics(text, env.getFontRenderContext());
            final Matrix currentMatrix = drawState.currentMatrix;
            final float ourX = (float)drawState.currentPoint.getX() - currentMatrix.getTranslateX();
            final float ourY = (float)drawState.currentPoint.getY() - currentMatrix.getTranslateY();
            drawState.drawers.add(new ITextDecorationDrawer(){

                @Override
                public void draw(PDPageContentStream stream) throws IOException {
                    float height = lineMetrics.getHeight();
                    float pdFontHeight = font.getBoundingBox().getHeight() / 1000.0f * attributeFont.getSize2D();
                    float scale = pdFontHeight / height;
                    float decent = lineMetrics.getDescent();
                    contentStream.transform(currentMatrix);
                    env.applyPaint(paint, new Rectangle2D.Float(ourX, ourY - decent * scale, stringWidth, height * scale));
                    float baseline = lineMetrics.getBaselineOffsets()[lineMetrics.getBaselineIndex()];
                    if (isStrikeThrough) {
                        env.applyStroke(new BasicStroke(PdfBoxGraphics2DFontTextDrawer.this.getSensibleThickness(lineMetrics.getStrikethroughThickness(), attributeFont)));
                        float strikethroughOffset = scale * (baseline + lineMetrics.getStrikethroughOffset());
                        contentStream.moveTo(ourX, ourY - strikethroughOffset);
                        contentStream.lineTo(ourX + stringWidth, ourY - strikethroughOffset);
                        contentStream.stroke();
                    }
                    if (isUnderline) {
                        env.applyStroke(new BasicStroke(PdfBoxGraphics2DFontTextDrawer.this.getSensibleThickness(lineMetrics.getUnderlineThickness(), attributeFont)));
                        float underlineOffset = scale * (baseline + lineMetrics.getUnderlineOffset());
                        contentStream.moveTo(ourX, ourY - underlineOffset);
                        contentStream.lineTo(ourX + stringWidth, ourY - underlineOffset);
                        contentStream.stroke();
                    }
                }
            });
        }
        Point2D.Double deltaPoint = new Point2D.Double(stringWidth, 0.0);
        assert (drawState.currentMatrix != null);
        drawState.currentMatrix.transform(deltaPoint);
        drawState.deltaPoint = deltaPoint;
        drawState.currentPoint = new Point2D.Double(drawState.currentPoint.getX() + ((Point2D)deltaPoint).getX(), drawState.currentPoint.getY() + ((Point2D)deltaPoint).getY());
    }

    private float getSensibleThickness(float thickness, Font font) {
        if (thickness < 1.0E-5f) {
            return 0.04f * font.getSize2D();
        }
        return thickness;
    }

    private PDFont applyFont(Font font, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        PDFont fontToUse = this.mapFont(font, env);
        if (fontToUse == null) {
            fontToUse = PdfBoxGraphics2DFontTextDrawerDefaultFonts.chooseMatchingHelvetica(font);
        }
        env.getContentStream().setFont(fontToUse, font.getSize2D());
        return fontToUse;
    }

    protected PDFont mapFont(Font font, final IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) throws IOException, FontFormatException {
        for (final FontEntry fontEntry : this.fontFiles) {
            if (fontEntry.overrideName == null) {
                Font javaFont = Font.createFont(0, fontEntry.file);
                fontEntry.overrideName = javaFont.getFontName();
            }
            if (fontEntry.file.getName().toLowerCase(Locale.US).endsWith(".ttc")) {
                TrueTypeCollection collection = new TrueTypeCollection(fontEntry.file);
                collection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    @Override
                    public void process(TrueTypeFont ttf) throws IOException {
                        PDType0Font pdFont = PDType0Font.load(env.getDocument(), ttf, true);
                        PdfBoxGraphics2DFontTextDrawer.this.fontMap.put(fontEntry.overrideName, pdFont);
                        PdfBoxGraphics2DFontTextDrawer.this.fontMap.put(pdFont.getName(), pdFont);
                    }
                });
                continue;
            }
            PDType0Font pdFont = PDType0Font.load(env.getDocument(), fontEntry.file);
            this.fontMap.put(fontEntry.overrideName, pdFont);
        }
        this.fontFiles.clear();
        return this.fontMap.get(font.getFontName());
    }

    private boolean iterateRun(AttributedCharacterIterator iterator, StringBuilder sb) {
        sb.setLength(0);
        int charCount = iterator.getRunLimit() - iterator.getRunStart();
        while (charCount-- > 0) {
            char c = iterator.current();
            iterator.next();
            if (c == '\uffff') {
                return false;
            }
            sb.append(c);
        }
        return iterator.getIndex() < iterator.getRunLimit();
    }

    private static class DrawTextDecorationState {
        final List<ITextDecorationDrawer> drawers = new ArrayList<ITextDecorationDrawer>();
        public Matrix currentMatrix;
        private final PDPageContentStream contentStream;
        public Point2D currentPoint;
        public Point2D deltaPoint = new Point2D.Float(0.0f, 0.0f);

        public DrawTextDecorationState(PDPageContentStream contentStream) {
            this.contentStream = contentStream;
        }

        private void setCurrentTextMatrix(AffineTransform newAT) throws IOException {
            Matrix newMatrix = new Matrix(newAT);
            if (!newMatrix.equals(this.currentMatrix)) {
                this.currentMatrix = newMatrix;
                this.contentStream.setTextMatrix(this.currentMatrix);
            }
        }
    }

    private static interface ITextDecorationDrawer {
        public void draw(PDPageContentStream var1) throws IOException;
    }

    private static class FontEntry {
        String overrideName;
        File file;

        private FontEntry() {
        }
    }
}

