/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookProvider;
import org.apache.poi.util.Internal;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@Internal
public class XSSFWorkbookFactory
implements WorkbookProvider {
    @Override
    public boolean accepts(FileMagic fm) {
        return fm == FileMagic.OOXML;
    }

    @Override
    public XSSFWorkbook create() {
        return new XSSFWorkbook();
    }

    @Override
    public XSSFWorkbook create(DirectoryNode root, String password) throws IOException {
        try (InputStream stream = DocumentFactoryHelper.getDecryptedStream(root, password);){
            XSSFWorkbook xSSFWorkbook = this.create(stream);
            return xSSFWorkbook;
        }
    }

    @Override
    public Workbook create(InputStream inp, String password) throws IOException {
        InputStream bufInp = FileMagic.prepareToCheckMagic(inp);
        FileMagic fm = FileMagic.valueOf(bufInp);
        if (fm == FileMagic.OLE2) {
            try (POIFSFileSystem poifs = new POIFSFileSystem(bufInp);){
                XSSFWorkbook xSSFWorkbook;
                block13: {
                    InputStream stream = DocumentFactoryHelper.getDecryptedStream(poifs.getRoot(), password);
                    try {
                        xSSFWorkbook = this.create(stream);
                        if (stream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return xSSFWorkbook;
            }
        }
        if (fm == FileMagic.OOXML) {
            return this.create(bufInp);
        }
        return null;
    }

    @Override
    public XSSFWorkbook create(InputStream stream) throws IOException {
        try {
            OPCPackage pkg = OPCPackage.open(stream);
            return XSSFWorkbookFactory.createWorkbook(pkg);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    public static XSSFWorkbook createWorkbook(OPCPackage pkg) throws IOException {
        try {
            return new XSSFWorkbook(pkg);
        }
        catch (RuntimeException ioe) {
            pkg.revert();
            throw ioe;
        }
    }

    @Override
    public XSSFWorkbook create(File file, String password, boolean readOnly) throws IOException {
        FileMagic fm = FileMagic.valueOf(file);
        if (fm == FileMagic.OLE2) {
            try (POIFSFileSystem poifs = new POIFSFileSystem(file, true);){
                XSSFWorkbook xSSFWorkbook;
                block14: {
                    InputStream stream = DocumentFactoryHelper.getDecryptedStream(poifs.getRoot(), password);
                    try {
                        xSSFWorkbook = this.create(stream);
                        if (stream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return xSSFWorkbook;
            }
        }
        try {
            OPCPackage pkg = OPCPackage.open(file, readOnly ? PackageAccess.READ : PackageAccess.READ_WRITE);
            return XSSFWorkbookFactory.createWorkbook(pkg);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }
}

