/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.csc;

import com.ssl.doc.signing.tool.csc.CredentialInfo;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.http.HTTPClient;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CscApi {
    private String accessToken;
    private String CscEndpoint;

    public CscApi(String accessToken, String CscEndpoint) {
        this.accessToken = accessToken;
        this.CscEndpoint = CscEndpoint;
    }

    public String[] getCredentialIDs(String certificateType) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put("clientData", certificateType);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/list", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            JSONObject errorJson = (JSONObject)responseParser.parse(responseJson.toJSONString());
            if (errorJson.get("error_description") != null) {
                String errorDesc = (String)errorJson.get("error_description");
                if (errorDesc.contains("Signing credentials not configured. Make sure certificate is issued before signing")) {
                    return new String[0];
                }
                throw new CscApiException(responseJson.toJSONString());
            }
            throw new CscApiException(responseJson.toJSONString());
        }
        JSONArray credendialIdsArr = (JSONArray)responseJson.get("credentialIDs");
        String[] credentialIds = new String[credendialIdsArr.size()];
        credendialIdsArr.toArray(credentialIds);
        return credentialIds;
    }

    public CredentialInfo getCredentialInfo(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put("credentialID", credentialId);
        body.put("certificates", "chain");
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/info", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            throw new CscApiException(responseJson.toJSONString());
        }
        JSONObject cert = (JSONObject)responseJson.get("cert");
        JSONArray certArr = (JSONArray)cert.get("certificates");
        ArrayList<X509Certificate> certsList = new ArrayList<X509Certificate>();
        for (String certificateBase64 : certArr) {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            byte[] decodedCert = Base64.getDecoder().decode(certificateBase64);
            X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(decodedCert));
            certsList.add(certificate);
        }
        JSONObject key = (JSONObject)responseJson.get("key");
        JSONArray algo = (JSONArray)key.get("algo");
        String sigAlgo = (String)algo.get(0);
        CredentialInfo credentialInfo = new CredentialInfo();
        credentialInfo.setCerts(certsList);
        credentialInfo.setSignatureAlgorithm(sigAlgo);
        return credentialInfo;
    }

    public String getCredentialsAuthorize(String credentialId, int numOfSignatures, String[] hashes, String otp) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONArray hashesArr = new JSONArray();
        for (String hash : hashes) {
            hashesArr.add(hash);
        }
        JSONObject body = new JSONObject();
        body.put("credentialID", credentialId);
        body.put("numSignatures", numOfSignatures);
        body.put("hash", hashesArr);
        if (otp != null) {
            body.put("OTP", otp);
        }
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/authorize", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            String errorDesc = (String)responseJson.get("error_description");
            throw new CscApiException(errorDesc);
        }
        String sad = (String)responseJson.get("SAD");
        return sad;
    }

    public String[] signHash(String credentialId, String sad, String[] hashes, String sigAlgo) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONArray hashesArr = new JSONArray();
        for (String hash : hashes) {
            hashesArr.add(hash);
        }
        JSONObject body = new JSONObject();
        body.put("credentialID", credentialId);
        body.put("SAD", sad);
        body.put("hash", hashesArr);
        body.put("signAlgo", sigAlgo);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/signatures/signHash", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            String errorDesc = (String)responseJson.get("error_description");
            throw new CscApiException(errorDesc);
        }
        JSONArray signaturesArr = (JSONArray)responseJson.get("signatures");
        String[] signatures = new String[signaturesArr.size()];
        signaturesArr.toArray(signatures);
        return signatures;
    }

    public boolean isOtpTypeOnline(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put("credentialID", credentialId);
        body.put("authInfo", true);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/info", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            throw new CscApiException(responseJson.toJSONString());
        }
        String authMode = (String)responseJson.get("authMode");
        if (authMode.equals("implicit")) {
            return false;
        }
        JSONObject otp = (JSONObject)responseJson.get("OTP");
        String otpType = (String)otp.get("type");
        return authMode.equals("explicit") && otpType.equals("online");
    }

    public void sendOtp(String credentialId) throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        reqHeaders.put("Authorization", "Bearer " + this.accessToken);
        JSONObject body = new JSONObject();
        body.put("credentialID", credentialId);
        HTTPClient client = new HTTPClient(this.CscEndpoint + "/csc/v0/credentials/sendOTP", reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        if (client.getHttpStatus() != 204) {
            JSONParser responseParser = new JSONParser();
            JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
            throw new CscApiException(responseJson.toJSONString());
        }
    }
}

