/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.dsig.SignatureMethod;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.BigIntegers;

public final class SignatureUtils {
    public static String sign(String hash, PrivateKey privateKey) throws Exception {
        Signature signature = SignatureMethod.getSignature(SignatureMethod.RSA_SHA256, HashAlgorithm.none);
        signature.initSign(privateKey);
        signature.update(Base64.getDecoder().decode(hash));
        return Base64.getEncoder().encodeToString(signature.sign());
    }

    public static byte[] toPlainDSASignatureValue(byte[] asn1SignatureValue) throws Exception {
        BigInteger order = SignatureUtils.getOrderFromSignatureValue(asn1SignatureValue);
        BigInteger[] values = StandardDSAEncoding.INSTANCE.decode(order, asn1SignatureValue);
        return PlainDSAEncoding.INSTANCE.encode(order, values[0], values[1]);
    }

    public static BigInteger getOrderFromSignatureValue(byte[] signatureValue) throws IOException {
        BigInteger sValue;
        BigInteger rValue;
        if (SignatureUtils.isAsn1EncodedSignatureValue(signatureValue)) {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(signatureValue);
            if (seq.size() != 2) {
                throw new IllegalArgumentException("ASN1 Sequence size should be 2!");
            }
            rValue = ((ASN1Integer)seq.getObjectAt(0)).getValue();
            sValue = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        } else {
            if (signatureValue.length % 2 != 0) {
                throw new IllegalArgumentException("Signature value binaries length shall be dividable by 2!");
            }
            int valueLength = signatureValue.length / 2;
            rValue = BigIntegers.fromUnsignedByteArray(signatureValue, 0, valueLength);
            sValue = BigIntegers.fromUnsignedByteArray(signatureValue, valueLength, valueLength);
        }
        BigInteger max = rValue.max(sValue);
        return max.add(BigInteger.ONE);
    }

    public static boolean isAsn1EncodedSignatureValue(byte[] binaries) {
        boolean bl;
        ASN1InputStream is = new ASN1InputStream(binaries);
        try {
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            bl = seq != null && seq.size() == 2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        is.close();
        return bl;
    }
}

