/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.dsig;

import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.dsig.SignatureAlg;

public enum SignatureMethod {
    RSA_SHA1(SignatureAlg.RSA, "SHA-1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1"),
    RSA_SHA256(SignatureAlg.RSA, "SHA-256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"),
    RSA_SHA384(SignatureAlg.RSA, "SHA-384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"),
    RSA_SHA512(SignatureAlg.RSA, "SHA-512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"),
    ECDSA_SHA1(SignatureAlg.ECDSA, "SHA-1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"),
    ECDSA_SHA224(SignatureAlg.ECDSA, "SHA-224", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"),
    ECDSA_SHA256(SignatureAlg.ECDSA, "SHA-256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"),
    ECDSA_SHA384(SignatureAlg.ECDSA, "SHA-384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"),
    ECDSA_SHA512(SignatureAlg.ECDSA, "SHA-512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");

    private final String name;
    private final String hashAlgo;
    private final String uri;

    private SignatureMethod(String name, String hashAlg, String uri) {
        this.name = name;
        this.hashAlgo = hashAlg;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public String getHashAlgo() {
        return this.hashAlgo;
    }

    public String getUri() {
        return this.uri;
    }

    public static SignatureMethod findSignatureAlgo(String signatureAlgo, String hashAlgo) throws Exception {
        for (SignatureMethod signatureMethod : SignatureMethod.values()) {
            if (!signatureMethod.name.equals(signatureAlgo) || !signatureMethod.hashAlgo.equals(hashAlgo)) continue;
            return signatureMethod;
        }
        throw new Exception(String.format("Invalid signature algo: %s and hash algo: %s", signatureAlgo, hashAlgo));
    }

    public static Signature getSignature(SignatureMethod signAlgo, HashAlgorithm algo) throws NoSuchAlgorithmException {
        String ecmaString = HashAlgorithm.none == algo ? "NONE" : algo.ecmaString;
        return Signature.getInstance(ecmaString + "with" + signAlgo.getName());
    }
}

