#!/bin/bash

# shellcheck disable=SC2086

DOC_SIGN_HOME=/usr/share/docsigning_watch_folder
SERVICE_FILENAME="docsigning_watch_folder.service"

function remove()
{
    echo "Remove old Doc Signing Watcher installation files"
    echo "------------------------------------------------------------"

    # Stop servive if exists
    if [ -f "/etc/systemd/system/${SERVICE_FILENAME}" ]; then
      systemctl stop ${SERVICE_FILENAME}
      systemctl --no-pager status  ${SERVICE_FILENAME}
      systemctl daemon-reload
    fi

    # Remove old installation folder
    rm -rf ${DOC_SIGN_HOME}

    echo "------------------------------------------------------------"
}

function setup()
{
  echo "Copy file into ${DOC_SIGN_HOME}"

  # Copy java app
  mkdir -p ${DOC_SIGN_HOME}
  cp -ar doc_signing_watch_folder-2.1.0.jar ${DOC_SIGN_HOME}/doc_signing_watch_folder-2.1.0.jar

  # Created log paths
  mkdir -p ${DOC_SIGN_HOME}/logs

  # Copy app start script
  mkdir -p ${DOC_SIGN_HOME}/bin
  cp -ar bin/docsigner ${DOC_SIGN_HOME}/bin/docsigner

  # Copy config files
  cp -ar log4j2.xml ${DOC_SIGN_HOME}/log4j2.xml
  cp -ar doc_signing_watch_folder.yaml ${DOC_SIGN_HOME}/doc_signing_watch_folder.yaml

  # Copy fonts
  mkdir -p ${DOC_SIGN_HOME}/fonts
  cp -ar fonts/GoNotoKurrent.ttf ${DOC_SIGN_HOME}/fonts/GoNotoKurrent.ttf

  # Copy service file
  cp -ar systemd/${SERVICE_FILENAME} /etc/systemd/system/${SERVICE_FILENAME}

  # Give execute permission to startup script
  chmod +x ${DOC_SIGN_HOME}/bin/docsigner

  echo "------------------------------------------------------------"
}

function installJDK()
{
    echo "OpenJDK Installing"
    echo "------------------------------------------------------------"

    # Install JDK
    JAVA_VERSION="jdk-11.0.2"
    JAVA_TGZ_FILENAME="openjdk-11.0.2_linux-x64_bin.tar.gz"
    JAVA_DOWNLOAD_URL="https://download.java.net/java/GA/jdk11/9/GPL/openjdk-11.0.2_linux-x64_bin.tar.gz"

    rm -rf ${JAVA_VERSION} || true
    rm -rf ${JAVA_TGZ_FILENAME} || true

    wget --no-check-certificate --no-cookies ${JAVA_DOWNLOAD_URL}
    tar -xzf ${JAVA_TGZ_FILENAME}
    mkdir -p "${DOC_SIGN_HOME}"/jdk
    mv ./${JAVA_VERSION}/* "${DOC_SIGN_HOME}"/jdk/.

    rm -rf ${JAVA_TGZ_FILENAME} || true
    rm -rf ${JAVA_VERSION} || true

    "${DOC_SIGN_HOME}"/jdk/bin/java -version

    echo "------------------------------------------------------------"
}

if [[ $(whoami) != root ]]; then
  echo "Please login as root user to run this script.... Thanks!"
  exit 1
fi

echo "######################################################################################################################"
echo "######################################## Installing Doc Signing Watch Folder #########################################"
echo "######################################################################################################################"

# Remove old installation files
remove

# Setup DocSigning service
setup

# Install Java JDK
#installJDK

# Any script here will happen after the tar file extract.
systemctl daemon-reload
systemctl enable  ${SERVICE_FILENAME}
systemctl restart ${SERVICE_FILENAME}
systemctl --no-pager status  ${SERVICE_FILENAME}

echo "Completed installing"
exit 0

